/*
 * Decompiled with CFR 0.152.
 */
package com.Influence.smoothboot.mixin;

import com.Influence.smoothboot.SmoothBoot;
import com.Influence.smoothboot.util.LoggingForkJoinWorkerThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_10207;
import net.minecraft.class_156;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_156.class})
public abstract class BootstrapMixin {
    @Unique
    private static class_10207 SMOOTHBOOT_BOOTSTRAP_EXECUTOR;
    @Unique
    private static volatile boolean isInBootstrapPhase;
    @Unique
    private static final AtomicInteger BOOTSTRAP_WORKER_ID;

    @Inject(method={"<clinit>()V"}, at={@At(value="HEAD")})
    private static void onClassInit(CallbackInfo ci) {
        SmoothBoot.LOGGER.debug("[SmoothBoot] Util class loading - Bootstrap phase started");
        if (!SmoothBoot.initConfig) {
            SmoothBoot.regConfig();
            SmoothBoot.initConfig = true;
        }
        BootstrapMixin.createBootstrapExecutor();
    }

    @Inject(method={"<clinit>()V"}, at={@At(value="RETURN")})
    private static void onClassInitComplete(CallbackInfo ci) {
        SmoothBoot.LOGGER.debug("[SmoothBoot] Util class loaded - Bootstrap resources ready");
        BootstrapMixin.executeBootstrapTasks();
    }

    @Unique
    private static void createBootstrapExecutor() {
        if (SMOOTHBOOT_BOOTSTRAP_EXECUTOR != null) {
            return;
        }
        SmoothBoot.LOGGER.debug("[SmoothBoot] Creating custom Bootstrap executor");
        int bootstrapThreads = class_3532.method_15340((int)SmoothBoot.config.threadCount.bootstrap, (int)1, (int)Math.min(Runtime.getRuntime().availableProcessors(), 4));
        final int bootstrapPriority = SmoothBoot.config.threadPriority.bootstrap;
        ExecutorService executorService = bootstrapThreads <= 1 ? Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setName("SmoothBoot-Bootstrap-Thread");
            thread.setPriority(bootstrapPriority);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler(BootstrapMixin::bootstrapUncaughtExceptionHandler);
            return thread;
        }) : new ForkJoinPool(bootstrapThreads, pool -> {
            final String workerName = "SmoothBoot-Bootstrap-" + BOOTSTRAP_WORKER_ID.getAndIncrement();
            SmoothBoot.LOGGER.debug("[SmoothBoot] Initializing Bootstrap worker: {}", (Object)workerName);
            LoggingForkJoinWorkerThread worker = new LoggingForkJoinWorkerThread(pool, SmoothBoot.LOGGER){

                @Override
                protected void onStart() {
                    super.onStart();
                    this.setPriority(bootstrapPriority);
                    this.setName(workerName);
                }

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        SmoothBoot.LOGGER.warn("[SmoothBoot] Bootstrap worker {} terminated with exception", (Object)this.getName(), (Object)throwable);
                    } else {
                        SmoothBoot.LOGGER.debug("[SmoothBoot] Bootstrap worker {} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            return worker;
        }, BootstrapMixin::bootstrapUncaughtExceptionHandler, true);
        SMOOTHBOOT_BOOTSTRAP_EXECUTOR = new class_10207(executorService);
        SmoothBoot.initBootstrap = true;
        SmoothBoot.LOGGER.info("[SmoothBoot] Custom Bootstrap executor created with {} thread(s)", (Object)bootstrapThreads);
    }

    @Unique
    private static void bootstrapUncaughtExceptionHandler(Thread thread, Throwable throwable) {
        SmoothBoot.LOGGER.error("[SmoothBoot] Uncaught exception in Bootstrap thread {}: {}", (Object)thread.getName(), (Object)throwable.getMessage(), (Object)throwable);
        Thread.getDefaultUncaughtExceptionHandler().uncaughtException(thread, throwable);
    }

    @Unique
    private static void executeBootstrapTasks() {
        if (SMOOTHBOOT_BOOTSTRAP_EXECUTOR == null) {
            return;
        }
        SmoothBoot.LOGGER.debug("[SmoothBoot] Executing Bootstrap tasks");
        SMOOTHBOOT_BOOTSTRAP_EXECUTOR.execute(() -> SmoothBoot.LOGGER.debug("[SmoothBoot] Bootstrap task 1: Initializing core components"));
        SMOOTHBOOT_BOOTSTRAP_EXECUTOR.execute(() -> SmoothBoot.LOGGER.debug("[SmoothBoot] Bootstrap task 2: Preparing resources"));
        SMOOTHBOOT_BOOTSTRAP_EXECUTOR.execute(() -> {
            try {
                Thread.sleep(1000L);
                isInBootstrapPhase = false;
                SmoothBoot.LOGGER.debug("[SmoothBoot] Bootstrap phase completed, switching to main phase");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    @Unique
    private static class_10207 getSmoothBootBootstrapExecutor() {
        if (SMOOTHBOOT_BOOTSTRAP_EXECUTOR == null) {
            BootstrapMixin.createBootstrapExecutor();
        }
        return SMOOTHBOOT_BOOTSTRAP_EXECUTOR;
    }

    @Unique
    private static boolean isInBootstrapPhase() {
        return isInBootstrapPhase;
    }

    @Inject(method={"method_18349()Lnet/minecraft/class_10207;"}, at={@At(value="HEAD")})
    private static void onFirstMainExecutorAccess(CallbackInfoReturnable<class_10207> cir) {
        if (isInBootstrapPhase) {
            SmoothBoot.LOGGER.debug("[SmoothBoot] First access to main worker executor - Bootstrap phase ending");
        }
    }

    static {
        isInBootstrapPhase = true;
        BOOTSTRAP_WORKER_ID = new AtomicInteger(1);
    }
}

