/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.loader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigElement;
import com.teamresourceful.resourcefulconfig.api.types.elements.ResourcefulConfigEntryElement;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigObjectEntry;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigValueEntry;
import com.teamresourceful.resourcefulconfig.api.types.entries.SerializableObject;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryType;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import com.teamresourceful.resourcefulconfig.common.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;

public class Loader {
    public static void loadConfig(ResourcefulConfig config, JsonObject json) {
        Loader.forEach(config.elements(), (id, entry) -> {
            ResourcefulConfigValueEntry value;
            JsonElement data = json.get(id);
            if (data == null) {
                return;
            }
            if (entry instanceof ResourcefulConfigObjectEntry) {
                ResourcefulConfigObjectEntry objectEntry = (ResourcefulConfigObjectEntry)entry;
                Object patt0$temp = objectEntry.instance();
                if (patt0$temp instanceof SerializableObject) {
                    SerializableObject serializable = (SerializableObject)patt0$temp;
                    serializable.load(data);
                } else if (data instanceof JsonObject) {
                    JsonObject object = (JsonObject)data;
                    Loader.loadObject(objectEntry, object);
                }
            } else if (entry instanceof ResourcefulConfigValueEntry && !Loader.setValue(data, id, value = (ResourcefulConfigValueEntry)entry)) {
                ModUtils.log("Failed to set value for " + id);
            }
        });
        config.categories().forEach((id, category) -> {
            JsonElement data = json.get(id);
            if (!(data instanceof JsonObject)) {
                return;
            }
            JsonObject object = (JsonObject)data;
            Loader.loadConfig(category, object);
        });
    }

    private static void loadObject(ResourcefulConfigObjectEntry object, JsonObject json) {
        Loader.forEach(object.elements(), (id, entry) -> {
            if (entry instanceof ResourcefulConfigValueEntry) {
                ResourcefulConfigValueEntry value = (ResourcefulConfigValueEntry)entry;
                JsonElement data = json.get(id);
                if (data == null || data instanceof JsonObject) {
                    return;
                }
                if (!Loader.setValue(data, id, value)) {
                    ModUtils.log("Failed to set value for " + id);
                }
            }
        });
    }

    private static Object convert(JsonElement element, String id, ResourcefulConfigValueEntry entry) {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            ArrayList<Object> list = new ArrayList<Object>();
            array.forEach(e -> list.add(Loader.convert(e, id, entry)));
            list.removeIf(Objects::isNull);
            return list;
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                Number number = primitive.getAsNumber();
                return switch (entry.type()) {
                    case EntryType.BYTE -> number.byteValue();
                    case EntryType.SHORT -> number.shortValue();
                    case EntryType.INTEGER -> number.intValue();
                    case EntryType.LONG -> number.longValue();
                    case EntryType.FLOAT -> Float.valueOf(number.floatValue());
                    case EntryType.DOUBLE -> number.doubleValue();
                    default -> number;
                };
            }
            if (primitive.isString()) {
                if (entry.type() == EntryType.ENUM) {
                    Enum<?> value = ParsingUtils.parseEnum(entry.objectType(), primitive.getAsString());
                    if (value != null) {
                        return value;
                    }
                    ModUtils.log("Failed to parse enum value for " + id);
                }
                return primitive.getAsString();
            }
        }
        return null;
    }

    private static boolean setValue(JsonElement json, String id, ResourcefulConfigValueEntry data) {
        Object o = Loader.convert(json, id, data);
        if (o instanceof List) {
            List list = (List)o;
            return data.setArray(list.toArray());
        }
        if (o instanceof String) {
            String string = (String)o;
            return data.setString(string);
        }
        if (o instanceof Boolean) {
            Boolean booleanValue = (Boolean)o;
            return data.setBoolean(booleanValue);
        }
        if (o instanceof Short) {
            Short shortValue = (Short)o;
            return data.setShort(shortValue);
        }
        if (o instanceof Byte) {
            Byte byteValue = (Byte)o;
            return data.setByte(byteValue);
        }
        if (o instanceof Float) {
            Float floatValue = (Float)o;
            return data.setFloat(floatValue.floatValue());
        }
        if (o instanceof Integer) {
            Integer integerValue = (Integer)o;
            return data.setInt(integerValue);
        }
        if (o instanceof Long) {
            Long longValue = (Long)o;
            return data.setLong(longValue);
        }
        if (o instanceof Double) {
            Double doubleValue = (Double)o;
            return data.setDouble(doubleValue);
        }
        if (o instanceof Enum) {
            Enum enumValue = (Enum)o;
            return data.setEnum(enumValue);
        }
        return true;
    }

    private static void forEach(List<ResourcefulConfigElement> elements, BiConsumer<String, ResourcefulConfigEntry> consumer) {
        for (ResourcefulConfigElement element : elements) {
            if (!(element instanceof ResourcefulConfigEntryElement)) continue;
            ResourcefulConfigEntryElement entry = (ResourcefulConfigEntryElement)element;
            consumer.accept(entry.id(), entry.entry());
        }
    }
}

