/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types;

import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.range.OptionRange;
import java.util.List;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8015;
import org.jetbrains.annotations.NotNull;

public class RangeOptionWidget
extends BaseWidget {
    private static final int FOCUSED_EXTRA_WIDTH = 40;
    private static final int WIDTH = 80;
    private static final int FOCUSED_WIDTH = 120;
    private static final int PADDING = 20;
    private final Supplier<class_2561> display;
    private final class_2561 minDisplay;
    private final class_2561 maxDisplay;
    private final DoubleSupplier getter;
    private final DoubleConsumer setter;
    private final double step;
    private final boolean canBeFocused;
    private int padding = 5;
    private boolean canChangeValue;

    public RangeOptionWidget(OptionRange range) {
        this(range::toComponent, range.minComponent(), range.maxComponent(), range::getPercent, range::setPercent, range.getStepPercent());
    }

    public RangeOptionWidget(Supplier<class_2561> display, class_2561 minDisplay, class_2561 maxDisplay, DoubleSupplier getter, DoubleConsumer setter, Double step) {
        super(80, 16);
        this.display = display;
        this.minDisplay = minDisplay;
        this.maxDisplay = maxDisplay;
        this.getter = getter;
        this.setter = setter;
        this.step = step;
        this.canBeFocused = this.minDisplay != null && this.maxDisplay != null;
    }

    @Override
    public void applyCursor(class_332 graphics) {
        if (!this.method_49606()) {
            return;
        }
        graphics.method_74037(this.method_37303() ? class_11876.field_62457 : class_11876.field_62459);
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.updateIfFocused();
        graphics.method_52706(class_10799.field_56883, ModSprites.BUTTON, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
        graphics.method_52706(class_10799.field_56883, ModSprites.BUTTON_HOVER, this.method_46426() + this.padding, this.method_46427() + 5, this.field_22758 - this.padding * 2, this.field_22759 - 10);
        int sliderX = this.method_46426() + this.padding + (int)((double)(this.field_22758 - this.padding * 2) * this.getter.getAsDouble()) - (this.field_22759 - 6) / 2;
        graphics.method_52706(class_10799.field_56883, ModSprites.CONTAINER, sliderX, this.method_46427() + 4, this.field_22759 - 8, this.field_22759 - 8);
        class_2561 tooltip = null;
        if (mouseX >= this.method_46426() + this.padding && mouseX <= this.method_46426() + this.field_22758 - this.padding && mouseY >= this.method_46427() + 4 && mouseY <= this.method_46427() + this.field_22759 - 4) {
            tooltip = this.display.get();
            this.applyCursor(graphics);
        }
        if (this.method_25367() && this.canBeFocused) {
            RangeOptionWidget.method_52718((class_332)graphics, (class_327)this.font, (class_2561)this.minDisplay, (int)(this.method_46426() + 2), (int)(this.method_46427() + 2), (int)(this.method_46426() + this.padding - 2), (int)(this.method_46427() + this.field_22759 - 2), (int)-1);
            RangeOptionWidget.method_52718((class_332)graphics, (class_327)this.font, (class_2561)this.maxDisplay, (int)(this.method_46426() + this.field_22758 - this.padding + 2), (int)(this.method_46427() + 2), (int)(this.method_46426() + this.field_22758 - 2), (int)(this.method_46427() + this.field_22759 - 2), (int)-1);
            if (mouseX >= this.method_46426() + 2 && mouseX <= this.method_46426() + this.padding - 2) {
                tooltip = this.minDisplay;
            } else if (mouseX >= this.method_46426() + this.field_22758 - this.padding + 2 && mouseX <= this.method_46426() + this.field_22758 - 2) {
                tooltip = this.maxDisplay;
            }
        }
        if (tooltip != null && class_310.method_1551().field_1755 != null && this.method_49606()) {
            graphics.method_71274(List.of(tooltip.method_30937()), mouseX, mouseY);
        }
    }

    public void updateIfFocused() {
        if (!this.canBeFocused) {
            return;
        }
        if (this.field_22758 != 120 && this.method_25367()) {
            this.method_25358(120);
            this.method_46421(this.method_46426() - 40);
            this.padding = 20;
        } else if (this.field_22758 != 80 && !this.method_25367()) {
            this.method_25358(80);
            this.method_46421(this.method_46426() + 40);
            this.padding = 5;
        }
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (!focused) {
            this.canChangeValue = false;
        } else {
            class_8015 type = class_310.method_1551().method_48186();
            if (type.method_48182() || type == class_8015.field_41780) {
                this.canChangeValue = true;
            }
        }
    }

    public boolean method_25402(@NotNull class_11909 event, boolean bl) {
        if (this.method_49606()) {
            this.setValueFromMouse(event.comp_4798());
            return true;
        }
        return false;
    }

    public boolean method_25403(@NotNull class_11909 event, double dragX, double dragY) {
        if (this.method_49606() && event.method_74245() == 0) {
            this.setValueFromMouse(event.comp_4798());
            return true;
        }
        return false;
    }

    public boolean method_25404(class_11908 event) {
        if (event.method_74229()) {
            this.canChangeValue = !this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean leftArrow;
            boolean bl = leftArrow = event.method_74228() == 263;
            if (leftArrow || event.method_74228() == 262) {
                double step = leftArrow ? -this.step : this.step;
                double value = (this.getter.getAsDouble() + (step *= event.method_74239() ? 10.0 : 1.0)) / (double)(this.field_22758 - 8);
                this.setter.accept(class_3532.method_15350((double)value, (double)0.0, (double)1.0));
                return true;
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        if (!this.method_25370()) {
            return;
        }
        double correctX = mouseX - (double)(this.method_46426() + this.padding);
        double value = correctX / (double)(this.method_25368() - this.padding * 2);
        this.setter.accept(class_3532.method_15350((double)value, (double)0.0, (double)1.0));
    }
}

