/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.misc.draggable;

import com.teamresourceful.resourcefulconfig.api.types.info.TooltipProvider;
import com.teamresourceful.resourcefulconfig.api.types.info.Translatable;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.ListWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.misc.draggable.DraggableList;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

public class DraggableItem<T>
extends BaseWidget
implements ListWidget.Item {
    private static final int HEIGHT = 16;
    private final DraggableList<T> list;
    private final T value;
    private final Runnable remove;

    public DraggableItem(int width, DraggableList<T> list, T value, Runnable remove) {
        super(width, 16);
        this.list = list;
        this.value = value;
        this.remove = remove;
    }

    public void render(class_332 graphics, int x, int y, int mouseX, int mouseY, int flags) {
        boolean hovered = (flags & 1) != 0;
        boolean dragging = (flags & 2) != 0;
        boolean canDelete = (flags & 4) != 0;
        boolean fadeOut = (flags & 8) != 0;
        graphics.method_52707(class_10799.field_56883, ModSprites.ofButton(hovered && !dragging), x, y, this.method_25368(), this.method_25364(), fadeOut ? -2130706433 : -1);
        if (!dragging && hovered) {
            graphics.method_52707(class_10799.field_56883, ModSprites.DRAGGABLE, x + 4, y + 4, 8, 8, fadeOut ? -2130706433 : -1);
        }
        if (!dragging && hovered) {
            TooltipProvider provider;
            T t;
            boolean hoveringDelete;
            boolean bl = hoveringDelete = x + this.method_25368() - 16 <= mouseX;
            if (canDelete) {
                graphics.method_52707(class_10799.field_56883, ModSprites.DELETE, x + this.method_25368() - 12, y + 4, 8, 8, fadeOut ? -2130706433 : -1);
                if (this.minecraft.field_1755 != null && hoveringDelete) {
                    graphics.method_71276((class_2561)class_2561.method_43470((String)"Remove"), mouseX, mouseY);
                }
            }
            if (!hoveringDelete && this.minecraft.field_1755 != null && (t = this.value) instanceof TooltipProvider && (provider = (TooltipProvider)t).getTooltip() != null && !provider.getTooltip().getString().isBlank()) {
                class_327 font = this.minecraft.field_1772;
                graphics.method_51447(font, font.method_1728((class_5348)provider.getTooltip(), Integer.MAX_VALUE), mouseX, mouseY);
            }
            this.applyCursor(graphics);
        }
        int color = hovered ? -329226 : -9276296;
        DraggableItem.method_52718((class_332)graphics, (class_327)this.font, (class_2561)Translatable.toComponent(this.value), (int)(x + 16), (int)(y + 1), (int)(x + this.method_25368() - 32), (int)(y + this.method_25364() - 1), (int)(fadeOut ? class_9848.method_61330((int)128, (int)color) : color));
    }

    @Override
    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.list.isDraggingItem() && this.list.getDraggingItem() == this) {
            graphics.method_52706(class_10799.field_56883, ModSprites.ofButton(true), this.method_46426() + 1, this.method_46427(), this.method_25368() - 1, this.method_25364());
        } else {
            int flags = 0;
            if (this.method_49606()) {
                flags |= 1;
            }
            if (this.list.isDraggingItem()) {
                flags |= 2;
            }
            if (this.list.canDelete()) {
                flags |= 4;
            }
            this.render(graphics, this.method_46426(), this.method_46427(), mouseX, mouseY, flags);
        }
    }

    public boolean method_25402(@NotNull class_11909 event, boolean bl) {
        if (this.method_49606() && event.method_74245() == 0 && event.comp_4798() >= (double)(this.method_46426() + this.method_25368() - 16)) {
            this.remove.run();
            return true;
        }
        return false;
    }

    @Override
    public void setItemWidth(int width) {
        this.method_25358(width);
    }

    public T value() {
        return this.value;
    }
}

