/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.dontusecommand;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber
public class CommandDisablerCommand {
    private static final String CONFIG_FILE = Paths.get(FMLPaths.GAMEDIR.get().toString(), "/config/DUC.txt").toString();
    private static Set<String> disabledCommands = new HashSet<String>();

    private static void loadDisabledCommands() {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(CONFIG_FILE));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                disabledCommands.add(line.toLowerCase());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void reload(AddReloadListenerEvent event) {
        CommandDisablerCommand.loadDisabledCommands();
    }

    @SubscribeEvent
    public static void onCommand(CommandEvent event) {
        String fullCommand = event.getParseResults().getReader().getString().trim();
        String[] commandParts = fullCommand.split("\\s+");
        String command = commandParts[0].startsWith("/") ? commandParts[0].substring(1) : commandParts[0];
        if (disabledCommands.contains(command = command.toLowerCase())) {
            Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237113_((String)("Command \"" + command + "\" is disabled.")), false);
            event.setCanceled(true);
            return;
        }
        if (disabledCommands.contains(fullCommand.toLowerCase())) {
            Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237113_((String)("Command \"" + fullCommand.toLowerCase() + "\" is disabled.")), false);
            event.setCanceled(true);
        }
    }

    static {
        CommandDisablerCommand.loadDisabledCommands();
    }
}

