/*
 * Decompiled with CFR 0.152.
 */
package com.github.QPCrummer.slumber;

import com.github.QPCrummer.slumber.MinecraftServerInterface;
import com.github.QPCrummer.slumber.SlumberCommand;
import com.github.QPCrummer.slumber.TickManagerInterface;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_8915;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Slumber
implements ModInitializer {
    static final String CONFIG_VERSION_KEY = "config-version";
    static final String TOGGLE_KEY = "toggle";
    static final String FREEZE_DELAY_SECONDS_KEY = "freeze-delay-seconds";
    static final String SAFE_STARTING_KEY = "safe-starting";
    static final String SLEEP_TICK_SPEED = "sleep_tick_speed";
    static final String SLEEP_AUTOSAVING = "sleep_autosaving";
    static final String DEBUG_KEY = "debug-messages";
    private static final Path config = FabricLoader.getInstance().getConfigDir().resolve("slumber.properties");
    public static final Properties properties = new Properties();
    public static final String cfgver = "1.4";
    public static int delay = -1;
    public static float sleep_tick_speed;
    public static boolean enabled;
    public static boolean safe_starting;
    public static boolean autosaving;
    public static boolean debug;
    private static long beginningTime;
    private static long endingTime;
    private static final ScheduledExecutorService wait;
    private static volatile ScheduledFuture<?> task;
    private static final Logger logger;

    public void onInitialize() {
        if (Files.notExists(config, new LinkOption[0])) {
            try {
                Slumber.storecfg();
            }
            catch (IOException e) {
                logger.error("Config storing failed", (Throwable)e);
            }
        } else {
            try {
                Slumber.loadcfg();
            }
            catch (IOException e) {
                logger.error("Config creation failed", (Throwable)e);
            }
            if (!Objects.equals(properties.getProperty(CONFIG_VERSION_KEY), cfgver)) {
                properties.setProperty(CONFIG_VERSION_KEY, cfgver);
                try {
                    Slumber.storecfg();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                Slumber.parse();
            }
        }
        SlumberCommand.register();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            if (safe_starting) {
                ((TickManagerInterface)server.method_54833()).setFrozenNoPacket(true);
                Slumber.calculateTimeElapsed(true);
                Slumber.sendToDebugLogger("Safe Starting Active");
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (enabled) {
                if (sleep_tick_speed > 0.0f) {
                    ((TickManagerInterface)server.method_54833()).setFrozenNoPacket(false);
                    Slumber.changeTickRateAction(true, server.method_54833());
                } else {
                    ((TickManagerInterface)server.method_54833()).setFrozenNoPacket(true);
                }
            } else {
                ((TickManagerInterface)server.method_54833()).setFrozenNoPacket(false);
            }
            Slumber.calculateTimeElapsed(enabled);
            if (safe_starting) {
                Slumber.sendToDebugLogger("Safe Starting Finished; Continued Freeze: " + enabled);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (enabled) {
                ScheduledFuture<?> future = task;
                if (future != null && !future.isDone()) {
                    future.cancel(false);
                }
                Slumber.freeze(false, server);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (enabled && server.method_3788() <= 1) {
                task = wait.schedule(() -> {
                    if (server.method_3788() == 0) {
                        server.execute(() -> Slumber.freeze(true, server));
                    }
                }, (long)delay, TimeUnit.SECONDS);
            }
        });
    }

    public static void storecfg() throws IOException {
        try (OutputStream output = Files.newOutputStream(config, StandardOpenOption.CREATE);){
            Slumber.fillDefaults();
            properties.store(output, null);
        }
        Slumber.parse();
    }

    private static void fillDefaults() {
        Slumber.checkProperty(CONFIG_VERSION_KEY, cfgver);
        Slumber.checkProperty(SAFE_STARTING_KEY, "true");
        Slumber.checkProperty(FREEZE_DELAY_SECONDS_KEY, "20");
        Slumber.checkProperty(TOGGLE_KEY, "true");
        Slumber.checkProperty(DEBUG_KEY, "false");
        Slumber.checkProperty(SLEEP_TICK_SPEED, "0.0");
        Slumber.checkProperty(SLEEP_AUTOSAVING, "false");
    }

    private static void checkProperty(String key, String defaultValue) {
        if (!properties.containsKey(key)) {
            properties.setProperty(key, defaultValue);
        }
    }

    public static void loadcfg() throws IOException {
        try (InputStream input = Files.newInputStream(config, new OpenOption[0]);){
            properties.load(input);
        }
    }

    public static void parse() {
        Slumber.fillDefaults();
        delay = Integer.parseInt(properties.getProperty(FREEZE_DELAY_SECONDS_KEY));
        enabled = Boolean.parseBoolean(properties.getProperty(TOGGLE_KEY));
        safe_starting = Boolean.parseBoolean(properties.getProperty(SAFE_STARTING_KEY));
        debug = Boolean.parseBoolean(properties.getProperty(DEBUG_KEY));
        sleep_tick_speed = Float.parseFloat(properties.getProperty(SLEEP_TICK_SPEED));
        autosaving = Boolean.parseBoolean(properties.getProperty(SLEEP_AUTOSAVING));
    }

    public static void freeze(boolean frozen, MinecraftServer server) {
        class_8915 tickManager = server.method_54833();
        if (enabled) {
            if (sleep_tick_speed > 0.0f) {
                Slumber.changeTickRateAction(frozen, tickManager);
            } else {
                Slumber.freezeServerAction(frozen, tickManager);
            }
            if (!autosaving) {
                ((MinecraftServerInterface)server).setAutoSave(!frozen);
            }
        }
        float realTPS = sleep_tick_speed > 0.0f ? tickManager.method_54748() : 0.0f;
        Slumber.sendToDebugLogger("Enabled:" + enabled + ", Frozen: " + tickManager.method_54754() + ", Trying to Freeze: " + frozen + ", TPS: " + realTPS);
    }

    private static void freezeServerAction(boolean frozen, class_8915 tickManager) {
        if (tickManager.method_54754() != frozen) {
            ((TickManagerInterface)tickManager).setFrozenNoPacket(frozen);
            Slumber.calculateTimeElapsed(frozen);
            Slumber.sendToDebugLogger("Frozen: " + frozen);
        }
    }

    private static void changeTickRateAction(boolean frozen, class_8915 tickManager) {
        if (frozen) {
            ((TickManagerInterface)tickManager).setTickRateNoPacket(sleep_tick_speed);
        } else {
            ((TickManagerInterface)tickManager).setTickRateNoPacket(20.0f);
        }
        Slumber.sendToDebugLogger("TPS: " + tickManager.method_54748());
        Slumber.calculateTimeElapsed(frozen);
    }

    public static void sendToDebugLogger(String message) {
        if (debug) {
            logger.info(message);
        }
    }

    private static void calculateTimeElapsed(boolean frozen) {
        if (debug) {
            if (frozen && beginningTime == 0L) {
                beginningTime = System.currentTimeMillis();
            } else if (!frozen && beginningTime != 0L && endingTime == 0L) {
                endingTime = System.currentTimeMillis();
            }
            if (endingTime != 0L) {
                int timeElapsed = (int)((endingTime - beginningTime) / 1000L);
                Slumber.sendToDebugLogger("Unfroze after " + timeElapsed + " seconds");
                beginningTime = 0L;
                endingTime = 0L;
            }
        }
    }

    static {
        wait = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).build());
        logger = LogManager.getLogger((String)"Slumber");
    }
}

